#!/bin/bash

#############################################
#                                           #
# VNET LOGIN SHELL VER 2.1.55.16 2025/04/24 #
#                                           #
#############################################

line=(`awk 'NR==2' /usr/local/vnet_auth/config.dat`)
arr2=( `echo $line | tr -s ',' ' '`)

vnet_path="/usr/local/vnet_auth/"
result=0
key=''

VnCount=`ps -ef | grep vnet-link | grep -v grep | wc -l`

kousin=`wget -q -O- 'https://ntm200.com/api/version_check_raspberrypi.php' | awk 'NR==1'`
this_ver=(`awk 'NR==1' /usr/local/vnet_auth/version.dat`)

echo ""
if [ "$this_ver" != "$kousin" ]; then
echo "VNETプラスは バージョン $this_ver です"
echo "VNETプラスの最新バージョン $kousin があります"
echo ""
echo "最新バージョンに更新しますか？(Yesの場合は Y または y を入力)"
read chkkousin
    #echo $chkkousin
    if [ "$chkkousin" = "Y" ] || [ "$chkkousin" = "y" ]; then
     if [ $VnCount -gt 0 ]; then
       # vnet-linkプロセスが起動していた場合
       # vnet-linkを終了
       VnPID=$(pgrep vnet-link)
       kill -9 $VnPID
echo "VNETプラスを停止しました"
     fi
echo "以下のコマンドでUPDATEを実行してください"
echo ""
echo "sudo ./update.sh"
echo ""
exit
    fi
else
echo "VNETプラスは 最新のバージョン($this_ver) です"
echo ""
fi
case "$1" in
  "stop")
    if [ $VnCount -gt 0 ]; then
      # vnet-linkプロセスが起動していた場合
      echo "ASアドレスを入力(例:http://192.168.xxx.xxx) ※　何も入力しない場合はデフォルトで「ntm200.com」が宛先になります。"
      read as_address
      if [ "${arr2[0]}" = "" ]; then
      echo "FQDNを入力(例:hoge.hoge.ntm200.com)"
      else
      echo "FQDNを入力(前回:"${arr2[0]}")　※　何も入力しない場合は前回の VNET ID を使用します。"
      fi
      read fqdn
      echo "パスワードを入力"
      stty -echo
      read password
      stty echo
      if [ "$fqdn" = "" ]; then
          fqdn=${arr2[0]}
      fi
      if [ "$as_address" = "" ]; then
        response=`wget -q -O- --post-data='fqdn='$fqdn'&password='$password'&query=logout' 'https://ntm200.com/api/login_check_json.php'`
      else
        response=`wget -q -O- --post-data='fqdn='$fqdn'&password='$password'&query=logout' $as_address'/api/login_check_json.php'`
      fi
      #echo $response
      result=`echo $response | grep -o '"result": "[^"]*' | grep -o '[^"]*$'`
      if [ "$result" = "1" ]; then
      echo "認証に成功しました"
      # vnet-linkを終了
      VnPID=$(pgrep vnet-link)
      kill -9 $VnPID
      /usr/local/vnet_auth/stop_log_rotation.sh
      echo "VNETを停止しました"
      else
      echo "認証に失敗しました"
      fi
    fi
  ;;
  *)

    #if [ $VnCount -gt 0 ]; then
      # vnet-linkプロセスが起動していた場合
      # vnet-linkを終了
    #  VnPID=$(pgrep vnet-link)
    #  kill -9 $VnPID
    #fi

    echo "ASアドレスを入力(例:http://192.168.xxx.xxx) ※　何も入力しない場合はデフォルトで「ntm200.com」が宛先になります。"
    read as_address
    if [ "${arr2[0]}" = "" ]; then
      echo "FQDNを入力(例:hoge.hoge.ntm200.com)"
    else
      echo "FQDNを入力(前回:"${arr2[0]}")　※　何も入力しない場合は前回の VNET ID を使用します。"
    fi
    read fqdn
    echo "パスワードを入力"
    stty -echo
    read password
    stty echo
    if [ "$fqdn" = "" ]; then
    	fqdn=${arr2[0]}
    fi
    if [ "$as_address" = "" ]; then
      response=`wget -q -O- --post-data='fqdn='$fqdn'&password='$password'&query=login' 'https://ntm200.com/api/login_check_json.php'`
    else
      response=`wget -q -O- --post-data='fqdn='$fqdn'&password='$password'&query=login' $as_address'/api/login_check_json.php'`      
      #ローカルのhttps接続のエラーはノーチェックとする
      #response=`wget -q -O- --no-check-certificate  --post-data='fqdn='$fqdn'&password='$password'&query=login' $as_address'/api/login_check_json_ts.php'
    fi
    #echo $response
    
    result=`echo $response | grep -o '"result": "[^"]*' | grep -o '[^"]*$'`
    key=`echo $response | grep -o '"key": "[^"]*' | grep -o '[^"]*$'`
    response_as_address=`echo $response | grep -o '"ad_address": "[^"]*' | grep -o '[^"]*$'`
    adptrun=`echo $response | grep -o '"adat_running": "[^"]*' | grep -o '[^"]*$'`
    is_OTP=`echo $response | grep -o '"isOTP": "[^"]*' | grep -o '[^"]*$'`

    #echo $adptrun
    if [ "$adptrun" = "1" ]; then
	echo "別デバイスが同じVNETIDで既に立ち上がっている可能性があります。同じVNETIDが複数存在すると動作を保証できません。"
        echo "このままログインを継続しますか?(Yesの場合は Y または y を入力)"
	read check_yes
	#echo $check_yes
        if [ "$check_yes" = "Y" ] || [ "$check_yes" = "y" ]; then
           if [ "$as_address" = "" ]; then
             response=`wget -q -O- --post-data='fqdn='$fqdn'&password='$password'&query=login&retry=true' 'https://ntm200.com/api/login_check_json.php'`
           else
             response=`wget -q -O- --post-data='fqdn='$fqdn'&password='$password'&query=login&retry=true' $as_address'/api/login_check_json.php'`
             #ローカルのhttps接続のエラーはノーチェックとする
             #response=`wget -q -O- --no-check-certificate  --post-data='fqdn='$fqdn'&password='$password'&query=login' $as_address'/api/login_check_json_ts.php'
           fi
             result=`echo $response | grep -o '"result": "[^"]*' | grep -o '[^"]*$'`
             key=`echo $response | grep -o '"key": "[^"]*' | grep -o '[^"]*$'`
             response_as_address=`echo $response | grep -o '"ad_address": "[^"]*' | grep -o '[^"]*$'`
             adptrun=`echo $response | grep -o '"adat_running": "[^"]*' | grep -o '[^"]*$'`
	     is_OTP=`echo $response | grep -o '"isOTP": "[^"]*' | grep -o '[^"]*$'`
 	     if [ "$is_OTP" = "1" ]; then
               echo "ワンタイム認証が設定されています。"
       	       echo "メールを確認してください。"
               echo "認証が完了したら任意のキーを入力してください。"
       	       echo "認証が完了しないと通信はできません。"
               read wait
    	      fi
        else
	  # keyをファイルに出力
          echo "ログイン処理を中断しました"
exit
        fi
     else
 	if [ "$is_OTP" = "1" ]; then
    	echo "ワンタイム認証が設定されています。"
    	echo "メールを確認してください。"
    	echo "認証が完了したら任意のキーを入力してください。"
    	echo "認証が完了しないと通信はできません。"
    	read wait
    	fi
    fi
    if [ "$result" = "1" ]; then
      echo "認証に成功しました"
      # keyをファイルに出力
      echo $key > "$vnet_path"kenad.key
      # adアドレスをファイルに出力（上書き）
      echo $response_as_address > "$vnet_path"config.dat
      # FQDNをファイルに出力（追記）
      echo $fqdn >> "$vnet_path"config.dat
      # グループ名をファイルに出力（追記）
      echo "vnet" >> "$vnet_path"config.dat
      # ipv4を取得
      ipv4=`hostname -I | awk '{print $1}'`
      # ipv6を取得
      ipv6=`ip a | grep -A 3 $ipv4 | grep inet6 | awk '{print $2}' | awk -F "/" '{print $1}'`
      # ipv4をファイルに出力（追記）
      echo $ipv4 >> "$vnet_path"config.dat
      # ipv6をファイルに出力（追記）
      echo $ipv6 >> "$vnet_path"config.dat

      if [ $VnCount -gt 0 ]; then
       # vnet-linkプロセスが起動していた場合
       # vnet-linkを終了
       VnPID=$(pgrep vnet-link)
       kill -9 $VnPID
      fi

      # VnProject.outを起動
      nohup "$vnet_path"vnet-link > /dev/null 2>&1 &
      /usr/local/vnet_auth/start_log_rotation.sh
    else
      echo "認証に失敗しました"
    fi
  ;;
esac
