#!/bin/bash
device="mode:EN"
log="log:OFF"
vnet_dir='/usr/local/vnet_auth/'
own=$(whoami)
#groups=$(groups)
groups=$(whoami)
domain="domain:ntm200.com"
resolv="resolv:ON"
mtu="mtu:1300"

if [ ! -e "$vnet_dir"VnProject.out ];then
  # VNETディレクトリ作成
  mkdir "$vnet_dir"

  # 空の設定ファイル作成
  #touch "$vnet_dir"sys_config.dat
  touch /usr/local/vnet_auth/sys_config.dat

  ln -s "$vnet_dir"VnProject.out "$vnet_dir"vnet-link

  # sys_config.dat書き込み
  #echo "$device"$'\n'"$log"$'\n'"$domain"$'\n'"$resolv"$'\n'"$mtu" > "$vnet_dir"sys_config.dat

  echo ${device} > /usr/local/vnet_auth/sys_config.dat
  echo ${log} >> /usr/local/vnet_auth/sys_config.dat
  echo ${domain} >> /usr/local/vnet_auth/sys_config.dat
  echo ${resolv} >> /usr/local/vnet_auth/sys_config.dat
  echo ${mtu} >> /usr/local/vnet_auth/sys_config.dat

  # monoインストール(Ubuntu 20.4)
  #apt -y install gnupg ca-certificates 2>> error.log
  #apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 3FA7E0328081BFF6A14DA29AA6A19B38D3D831EF 2>> error.log
  #echo "deb https://download.mono-project.com/repo/ubuntu stable-focal main" | sudo tee /etc/apt/sources.list.d/mono-official-stable.list 2>> error.log
  #apt update 2>> error.log
  #apt -y install mono-devel 2>> error.log

  # opensslライブラリインストール
  #apt-get install libssl-dev 2>> error.log
  apt-get -y install libevent-dev 2>> error.log
  apt-get -y install dnsmasq 2>>error.log
  
  # hosts書き込み
  # 「133.125.61.70」が含まれる行を削除
  hosts_data=$(sed '/^133.125.61.70*/d' /etc/hosts)
  echo "${hosts_data}" > /etc/hosts
  # 「153.126.186.101」が含まれる行を削除
  hosts_data_ntm20=$(sed '/^153.126.186.101*/d' /etc/hosts)
  echo "${hosts_data_ntm20}" > /etc/hosts
  # 最初の行に「133.125.61.70 ntm200.com」を追記
  hosts_data=$(sed -e "1i 133.125.61.70 ntm200.com" /etc/hosts)
  echo "${hosts_data}" > /etc/hosts
  # 最初の行に「153.126.186.101 ntm20.com」を追記
  hosts_data_ntm20=$(sed -e "1i 153.126.186.101 ntm20.com" /etc/hosts)
  echo "${hosts_data_ntm20}" > /etc/hosts 
  
  # dnsmasq.conf書き込み

  cp /etc/dnsmasq.conf /etc/dnsmasq_org.conf
  head_line=$(head -n 1 /etc/dnsmasq_org.conf)
  #echo ${head_line:0:1}
  if [ ${head_line:0:1} != "s" ]
  then
      touch /etc/dnsmasq.conf
      echo "server=/.ntm200.com/198.18.0.2" > /etc/dnsmasq.conf
  else
      touch /etc/dnsmasq.conf
  fi
  while read line
  do
    echo $line >> /etc/dnsmasq.conf
  done < /etc/dnsmasq_org.conf

  systemctl restart dnsmasq
fi

# リゾルバのセットアップ
#chmod 755 ./setup_resolver.sh
#./setup_resolver.sh


if [ ! -e "$vnet_dir"config.dat ];then
  touch "$vnet_dir"config.dat
fi

if [ ! -e "$vnet_dir"error.dat ];then
  touch "$vnet_dir"error.dat
fi

if [ ! -e "$vnet_dir"vip.dat ];then
  touch "$vnet_dir"vip.dat
fi

if [ ! -e "$vnet_dir"php.dat ];then
  apt-get install php 2>>error.log
  touch "$vnet_dir"php.dat
fi

if [ ! -e "$vnet_dir"sys_config.dat ];then
  touch "$vnet_dir"sys_config.dat
  echo ${device} > /usr/local/vnet_auth/sys_config.dat
  echo ${log} >> /usr/local/vnet_auth/sys_config.dat
  echo ${domain} >> /usr/local/vnet_auth/sys_config.dat
  echo ${resolv} >> /usr/local/vnet_auth/sys_config.dat
  echo ${mtu} >> /usr/local/vnet_auth/sys_config.dat
fi
# sys_config.dat書き込み
#echo "$device""$\n""$log""$\n""$domain""$\n""$resolv""$\n""$mtu" > "$vnet_dir"sys_config.dat

if [ ! -e "$vnet_dir"salt.dat ];then
  touch "$vnet_dir"salt.dat
fi

if [ ! -e "$vnet_dir"kenad.key ];then
  touch "$vnet_dir"kenad.key
fi

if [ ! -e "$vnet_dir"rip.dat ];then
  touch "$vnet_dir"rip.dat
fi

if [ ! -e "$vnet_dir"Debug.log ];then
  touch "$vnet_dir"Debug.log
fi

# ファイル配置
cp -f VnProject.out version.dat vnet.sh log_rotation change_pass.sh salt.php aes.php start_log_rotation.sh stop_log_rotation.sh "$vnet_dir"
#cp -f VnProject.out kill2.sh kill9.sh Vnet.exe vnet.ico start_service.sh stop_service.sh version.dat vnet str_jp.json start_log_rotation.sh stop_log_rotation.sh log_rotation vnet.sh "$vnet_dir"

#cp -f vnet_auth.desktop /usr/share/applications
#cp -f vnet_update.sh /usr/local/bin/

#FOR ubuntu22
if [ ! -e /usr/lib/aarch64-linux-gnu/libcrypt.so.1.1.0 ];then
cp -f libcrypt.so.1.1.0 /usr/lib/aarch64-linux-gnu/
chmod 644 /usr/lib/aarch64-linux-gnu/libcrypt.so.1.1.0
fi

if [ ! -e /usr/lib/aarch64-linux-gnu/libcrypto.so.1.1 ];then
cp -f libcrypto.so.1.1 /usr/lib/aarch64-linux-gnu/
chmod 644 /usr/lib/aarch64-linux-gnu/libcrypto.so.1.1
fi

# パーミッション設定
chmod 606 "$vnet_dir"sys_config.dat
chown "$own":"$groups" "$vnet_dir"sys_config.dat
chmod 606 "$vnet_dir"error.dat
chown "$own":"$groups" "$vnet_dir"error.dat
chmod 606 "$vnet_dir"config.dat
chown "$own":"$groups" "$vnet_dir"config.dat
chmod 606 "$vnet_dir"vip.dat
chown "$own":"$groups" "$vnet_dir"vip.dat
chmod 606 "$vnet_dir"version.dat
chown "$own":"$groups" "$vnet_dir"version.dat
chmod 606 "$vnet_dir"rip.dat
chown "$own":"$groups" "$vnet_dir"rip.dat
chmod 606 "$vnet_dir"salt.dat
chown "$own":"$groups" "$vnet_dir"salt.dat
chmod 606 "$vnet_dir"kenad.key
chown "$own":"$groups" "$vnet_dir"kenad.key
chmod 606 "$vnet_dir"Debug.log
chown "$own":"$groups" "$vnet_dir"Debug.log
#chmod 606 "$vnet_dir"str_jp.json
#chown "$own":"$groups" "$vnet_dir"str_jp.json
chmod 755 "$vnet_dir"log_rotation
chown "$own":"$groups" "$vnet_dir"log_rotation
#chmod u+s "$vnet_dir"log_rotation
chmod 755 "$vnet_dir"VnProject.out
chown "$own":"$groups" "$vnet_dir"VnProject.out
chmod u+s "$vnet_dir"vnet-link
chmod 755 "$vnet_dir"change_pass.sh
chown "$own":"$groups" "$vnet_dir"change_pass.sh
chmod 755 "$vnet_dir"salt.php
chown "$own":"$groups" "$vnet_dir"salt.php
chmod 755 "$vnet_dir"aes.php
chown "$own":"$groups" "$vnet_dir"aes.php
chmod 755 "$vnet_dir"start_log_rotation.sh
chown "$own":"$groups" "$vnet_dir"start_log_rotation.sh
chmod 755 "$vnet_dir"stop_log_rotation.sh
chown "$own":"$groups" "$vnet_dir"stop_log_rotation.sh
#chmod 444 "$vnet_dir"vnet.ico
#chown "$own":"$groups" "$vnet_dir"vnet.ico
#chmod 644 /usr/share/applications/vnet_auth.desktop
#chown "$own":"$groups" /usr/share/applications/vnet_auth.desktop
#chmod 755 "$vnet_dir"kill2.sh
#chown "$own":"$groups" "$vnet_dir"kill2.sh
#chmod 755 "$vnet_dir"kill9.sh
#chown "$own":"$groups" "$vnet_dir"kill9.sh
#chmod 755 "$vnet_dir"Vnet.exe
#chown "$own":"$groups" "$vnet_dir"Vnet.exe
#chmod 755 "$vnet_dir"start_service.sh
#chown "$own":"$groups" "$vnet_dir"start_service.sh
#chmod 755 "$vnet_dir"stop_service.sh
#chown "$own":"$groups" "$vnet_dir"stop_service.sh
#chmod 755 "$vnet_dir"vnet
#chown "$own":"$groups" "$vnet_dir"vnet
#chmod 755 /usr/local/bin/vnet_update.sh
#chown "$own":"$groups" /usr/local/bin/vnet_update.sh
#chmod 755 "$vnet_dir"start_log_rotation.sh
#chown "$own":"$groups" "$vnet_dir"start_log_rotation.sh
#chmod 755 "$vnet_dir"stop_log_rotation.sh
#chown "$own":"$groups" "$vnet_dir"stop_log_rotation.sh
chmod 755 "$vnet_dir"vnet.sh
chown "$own":"$groups" "$vnet_dir"vnet.sh

if [ ! -e "$vnet_dir"update.sh ];then
 cp -f update.sh "$vnet_dir"
 chmod 755 "$vnet_dir"update.sh
 chown "$own":"$groups" "$vnet_dir"update.sh
fi
# videophoneインストーラー実行
#chmod 755 videophone_install.sh
#chown "$own":"$groups" videophone_install.sh
#./videophone_install.sh

echo software installation succeeded
